document.getElementById("generate").addEventListener("click", function () {
  const useLowercase = document.getElementById("lowercase").checked;
  const useUppercase = document.getElementById("uppercase").checked;
  const useNumbers = document.getElementById("numbers").checked;
  const useSymbols = document.getElementById("symbols").checked;
  const length = parseInt(document.getElementById("length").value);
  document.getElementById("password").value = generatePassword(
    length,
    useLowercase,
    useUppercase,
    useNumbers,
    useSymbols
  );
});

function generatePassword(
  length,
  useLowercase,
  useUppercase,
  useNumbers,
  useSymbols
) {
  const lowercase = "abcdefghijklmnopqrstuvwxyz";
  const uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  const numbers = "0123456789";
  const symbols = "!@#$%^&*()_+[]{}|;:,.<>?";

  let charset = "";
  if (useLowercase) charset += lowercase;
  if (useUppercase) charset += uppercase;
  if (useNumbers) charset += numbers;
  if (useSymbols) charset += symbols;

  // En az 3 rakam garantisi geliyor burada
  let password = "";
  for (let i = 0; i < 3; i++) {
    const randomNumberIndex = Math.floor(Math.random() * numbers.length);
    password += numbers[randomNumberIndex];
  }

  // Geri kalan karakterler eklenecek ve birleştirilecek
  for (let i = 0; i < length - 3; i++) {
    const randomIndex = Math.floor(Math.random() * charset.length);
    password += charset[randomIndex];
  }

  // Karıştırarak sonuç elde etmek
  return shuffleString(password);
}

// Karıştırma fonksiyonu
function shuffleString(str) {
  const arr = str.split("");
  for (let i = arr.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [arr[i], arr[j]] = [arr[j], arr[i]]; // elemanları yer değiştir
  }
  return arr.join("");
}

document.getElementById("copy").addEventListener("click", function () {
  let passwordField = document.getElementById("password");
  passwordField.select(); // kopyalacak yer
  document.execCommand("copy"); // kopyala

  // alert('Şifre kopyalandı!'); // istersen uyarı göster
});
